#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>
#include <stack>
#include <cstring>

using namespace std;

const int MAX_N = 2005;

int n, match[MAX_N], low[MAX_N], num[MAX_N], cur_num, in_stack[MAX_N], scc[MAX_N], scc_num;
vector< int > ee[MAX_N], e[MAX_N], ans[MAX_N];
stack< int > s;

void tarjan(int u) {
    num[u] = low[u] = cur_num++;
    s.push(u);
    in_stack[u] = 1;

    for (int i = 0; i < e[u].size(); i++) {
        int v = e[u][i];

        if (num[v] < 0) {
            tarjan(v);
            low[u] = min(low[u], low[v]);
        } else if (in_stack[v]) {
            low[u] = min(low[u], low[v]);
        }
    }


    if (low[u] == num[u]) {

        int t;

        do {
            t = s.top();
            s.pop();

            in_stack[t] = 0;
            scc[t] = scc_num;
        } while (t != u);

        scc_num++;
    }
}

int main() {
    //ios_base::sync_with_stdio(false);
    //freopen(".in", "r", stdin);
    //freopen(".out", "w", stdout);

    scanf("%d", &n);

    for (int i = 0; i < n; i++) {
        int m;

        scanf("%d", &m);

        for (int j = 0; j < m; j++) {
            int u;

            scanf("%d", &u);

            --u;

            ee[i].push_back(u);
        }
    }

    for (int i = 0; i < n; i++) {
        scanf("%d", &match[i]);

        match[i]--;
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < ee[i].size(); j++) {
            if (ee[i][j] != match[i]) {
                e[i].push_back(match[ee[i][j]]);
            }
        }
    }

    memset(num, -1, sizeof(num));

    for (int i = 0; i < n; i++) {
        if (num[i] < 0) {
            tarjan(i);
        }
    }

    for (int i = 0; i < n; i++) {
        ans[i].push_back(match[i]);
        for (int j = 0; j < ee[i].size(); j++) {
            if (ee[i][j] != match[i] && scc[i] == scc[ee[i][j]]) {
                ans[i].push_back(ee[i][j]);
            }
        }
    }

    for (int i = 0; i < n; i++) {
        printf("%d ", ans[i].size());

        for (int j = 0; j < ans[i].size(); j++) {
            printf("%d ", ans[i][j] + 1);
        }

        printf("\n");
    }

    return 0;
}
